<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
?>
				<h1><a href="/onboarding/documentation/" class="underline">Documentation</a> &rarr; /disclosure - GET</h1>
				<h3 style="color: #EF0000;">This is a restricted call and may only be used by authorized applications.</h3>
				<p>The disclosure web service allows authorized applications to retrieve disclosure information and can be accessed by sending a GET request to /disclosure.</p>
				<h3>Authentication</h3>
				<p>
					The API authentication utilized is based upon hash message authentication code (HMAC). HMAC is an authentication method that combines a cryptographic hash function with a secret cryptographic key. After the successful registration of an application on the API, a public and private key like the example below will be provisioned for its use.
				</p>
				<p class="code">
					Public Key: eca415a13daaec88cabba68b81a2149c97800864acd9ef0e15b5b8426de2464d
					<br/>Private Key: 0097cd109a3b72df1f988e4a6e3e344ecc02cdab9a03736bc12463b7d1b889a8
				</p>
				<p>
					On every request that an application sends to the API they must include an Authorization header. The authorization header is a string that the API will utilize to confirm the identity, and the message content, of the sender. The authorization header consists of three parts. The first part is the API identifier, represented by the word "DAAS", which stands for Direct as a Service. The API identifier is followed by a space that separates it from the identifying content. The identifying content consists of the unique public key and the base64 encoded HMAC hash generated by the request content and the private key, delimited by a colon. An example of the authorization header is below.
				</p>
				<p class="code">
					Authorization: DAAS eca415a13daaec88cabba68b81a2149c97800864acd9ef0e15b5b8426de2464d: Y2UwOTMwNGRmYzhlNTQ0YTZiODlmMDkwYWQzOWY1ODZmNzI4OTE5NTc3ZTYyYWE2M2EwNThlMGIzMTZkZTZlZA==
				</p>
				<p>
					The HMAC string is generated by running an HMAC hash function on a plain text string and the application's private key. The plain text string that must be hashed using HMAC is constructed as follows:
					<ul>
						<li>HTTP Request Type</li>
						<li>Date</li>
						<li>Content-MD5 (Optional)</li>
						<li>URI</li>
					</ul>
					These values are separated by new line characters ("\n"). An example of the plain text string is below:
				</p>
				<p class="code">
					GET\n06/03/2013 12:13:56 EST\niB94gawbwUSiZy5FuruIOQ==\n/disclosure/format/json
				</p>
				<p>
					The string above is hashed with the application's private key using the SHA-256 algorithm. A snippet of JavaScript code showing an example of this is shown below:
				</p>
				<p class="code">
					var hashString = CryptoJS.HmacSHA256("GET\n06/03/2013 12:13:56 EDT\niB94gawbwUSiZy5FuruIOQ==\n/disclosure/format/json","0097cd109a3b72df1f988e4a6e3e344ecc02cdab9a03736bc12463b7d1b889a8");
					<br/>var base64 = encode64(""+hashString);
					<br/>var authorization = "DAAS eca415a13daaec88cabba68b81a2149c97800864acd9ef0e15b5b8426de2464d:"+base64;
				</p>
				<p>
					In the example above the Content MD5 is provided but this is an optional field. If the Content MD5 header is not specified then the hash should not have the MD5 specified either.
				</p>
				<h3>Headers</h3>
				<div class="column">
					<div class="left">
						<ul>
							<li>Authorization</li>
							<p>
								The first required header is the Authorization header covered in the Authentication section at the top of this page.
							</p>
							<li>Date or X-Daas-Date</li>
							<p>
								The second required header that must be included is the Date header. Some browsers will not let an application specify the Date header programmatically, so in this case it is also acceptable to use the X-Daas-Date header as the API will interpret them interchangeably. This header should be populated with the current date and time, in any standard format (including time zone information if not time zone agnostic), when the GET request is submitted. The value supplied in the Date header must match the value used in the creation of the hash string for the Authorization header.
							</p>
						</ul>
					</div>
					<div class="right">
						<ul>
							<li>Content-Md5</li>
							<p>
								The optional header is the Content-Md5 header. This header should contain an MD5 hash of the GET query string. If this header is specified then it must also be included in the hash string for the authorization header. This extra security measure is not typically necessary for GET requests, however the option is available so that the parameters sent in the GET request can be validated by the API as not having been tampered with in transit.
							</p>
						</ul>
					</div>
				</div>
				<h3>Arguments</h3>
				<p>
					There are 5 arguments that can be sent to the disclosure web service.
				</p>
				<div class="column">
					<div class="left">
						<ul>
							<li>First</li>
							<p>
								This is an optional field to search for a patient with a set first name.
							</p>
							<li>Last</li>
							<p>
								This is an optional field to search for a patient with a set last name.
							</p>
							<li>SSN</li>
							<p>
								This optional field is for searching by patient SSN.
							</p>
						</ul>
					</div>
					<div class="right">
						<ul>
							<li>Start</li>
							<p>
								This optional field is a unix timestamp to specify the earliest time in the log you want to retrieve.
							</p>
							<li>End</li>
							<p>
								This optional field is a unix timestamp to specify the latest time in the log you want to retrieve.
							</p>
						</ul>
					</div>
				</div>
				<h3>Example Response</h3>
				<ul>
					<li>Success</li>
						<ul>
							<li>HTTP-200, {"request_id": "8975","0":{"recipient": "test.euser@<?PHP echo DIRECT_DOMAIN;?>","first": "First","last": "Last","disclosed": "1403203517","received": "1403203533","title": "Summarization of Episode Note","sent_to": "<?PHP echo DIRECT_DOMAIN;?>", "received_from": "Department of Veterans Affairs", "username": "test.user","facility": "Direct Facility","purpose": "TREATMENT","ssn": "123456789","patient_id": "12345ABCD" }}</li>
						</ul>
					<li>Error</li>
						<ul>
							<li>HTTP-401, {"request_id":"2", "message": "Access Denied. Authentication Failed."}</li>
							<li>HTTP-422, {"request_id":"5","message":"'Start' contains invalid input","fields":["start"]}</li>
						</ul>
				</ul>
				<h3>Sample Code</h3>
				<p>
					The disclosure web service is constructed in the same manner that the validate web service is. Please click <a href="/onboarding/validate_example">here</a> to be taken to some sample code snippets for the validate web service and use that as a basis for creating the disclosure call.
				</p>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>